/************************************************************************
 * @file: LoggingInterface.h
 *
 * @version: 0.1
 *
 * @description: This header file contains definition for Interface class
 * LoggingInterface. LoggingInterface class is used for displaying the Logs
 * based on log level [Priority : Error, Warning, Info, Debug]. LoggingInterface
 * class is inherited by Streaming class for default implementation.
 *
 * @authors: Jens Lorenz, jlorenz@de.adit-jv.com 2015
 *           Vijay Palaniswamy, vijay.palaniswamy@in.bosch.com 2015
 *
 * @copyright (c) 2015 Advanced Driver Information Technology.
 * Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
 * All rights reserved.
 *
 ***********************************************************************/

#ifndef _ADIT_UTILITY_LOGGINGINTERFACE_H_
#define _ADIT_UTILITY_LOGGINGINTERFACE_H_

#include <iostream>
#include <string>


namespace adit
{

namespace utility
{

enum eLogLevel
{
    LL_ERROR = 0,
    LL_WARNING,
    LL_INFO,
    LL_DEBUG,
    LL_MAX
};

class LoggingInterface
{

public:

    LoggingInterface() {};
    virtual ~LoggingInterface() {};

    /**
     * This function will be called only for error logs.
     * @param[IN] data Contains error logs to display
    */
    virtual void error(const std::string& data) const = 0;

    /**
     * This function will be called only for warning logs.
     * @param[IN] data Contains warning logs to display
    */
    virtual void warning(const std::string& data) const = 0;

    /**
     * This function will be called only for info logs.
     * @param[IN] data Contains info logs to display
    */
    virtual void info(const std::string& data) const = 0;

    /**
     * This function will be called only for debug logs.
     * @param[IN] data Contains debug logs to display
    */
    virtual void debug(const std::string& data) const = 0;

    /**
     * This function will be called asynchronously for getting the log activation level.
     * It is used to avoid unnecessary concatenation of log messages and will be called before.
     * @return Active log level value
    */
    virtual eLogLevel checkLogLevel() const = 0;
};

} /* namespace utility */

} /* namespace adit */

#endif /* _ADIT_UTILITY_LOGGINGINTERFACE_H_ */
